
#define _SUPPRESS_PLIB_WARNING
#define _DISABLE_OPENADC10_CONFIGPORT_WARNING
#include <plib.h>
#include <xc.h>
#include <math.h>

// DEVCFG3
#pragma config PMDL1WAY = OFF           // Peripheral Module Disable Configuration (Allow only one reconfiguration)
#pragma config IOL1WAY = ON             // Peripheral Pin Select Configuration (Allow only one reconfiguration)

// DEVCFG2
#pragma config FPLLIDIV = DIV_2
#pragma config FPLLMUL = MUL_24
#pragma config FPLLODIV = DIV_4

// DEVCFG1
#pragma config FNOSC = FRCPLL              // Oscillator Selection Bits (Fast RC Osc with PLL)
#pragma config FSOSCEN = OFF            // Secondary Oscillator Enable (Enabled)
#pragma config IESO = OFF               // Internal/External Switch Over (Diasbled)
#pragma config POSCMOD = OFF            // Primary Oscillator Configuration (External clock/Primary osc disabled)
#pragma config OSCIOFNC = OFF           // CLKO Output Signal Active on the OSCO Pin (Disabled)
#pragma config FPBDIV = DIV_1           // Peripheral Clock Divisor (Pb_Clk is Sys_Clk)
#pragma config FCKSM = CSECMD           // Clock Switching and Monitor Selection (Clock Switch Enabled, FSCM Disabled)
#pragma config WDTPS = PS32768          // Watchdog Timer Postscaler (1:32768)
#pragma config WINDIS = OFF             // Watchdog Timer Window Enable (Watchdog Timer is in Non-Window Mode)
#pragma config FWDTEN = OFF             // Watchdog Timer Enable (WDT Disabled (SWDTEN Bit Controls))
#pragma config FWDTWINSZ = WINSZ_25     // Watchdog Timer Window Size (Window Size is 25%)

// DEVCFG0
#pragma config DEBUG = OFF              // Background Debugger Enable (Debugger is Enabled)
#pragma config JTAGEN = OFF             // JTAG Enable (JTAG Port Disabled)
#pragma config ICESEL = ICS_PGx3        // ICE/ICD Comm Channel Select (Communicate on PGEC2/PGED2)
#pragma config PWP = OFF                // Program Flash Write Protect (Disable)
#pragma config BWP = OFF                // Boot Flash Write Protect bit (Protection Disabled)
#pragma config CP = OFF                 // Code Protect (Protection Disabled)

#define SYS_FREQ (24000000L)

typedef int fixed;
    fixed Sinewave[4096] = { 0, 3294197, 6588386, 9882561, 13176711, 16470831, 19764912, 23058947, 26352927, 29646846, 32940694, 36234465, 39528151, 42821744, 46115236, 49408619,
			52701886, 55995030, 59288041, 62580913, 65873638, 69166207, 72458614, 75750851, 79042909, 82334781, 85626459, 88917936, 92209204, 95500255, 98791081, 102081674,
			105372028, 108662133, 111951983, 115241569, 118530884, 121819920, 125108670, 128397125, 131685278, 134973121, 138260647, 141547847, 144834714, 148121240, 151407418, 154693239,
			157978697, 161263783, 164548489, 167832808, 171116732, 174400253, 177683365, 180966058, 184248325, 187530158, 190811551, 194092494, 197372981, 200653003, 203932553, 207211623,
			210490205, 213768293, 217045877, 220322950, 223599506, 226875534, 230151030, 233425983, 236700387, 239974234, 243247517, 246520227, 249792357, 253063900, 256334846, 259605190,
			262874923, 266144037, 269412525, 272680379, 275947591, 279214154, 282480060, 285745301, 289009870, 292273759, 295536960, 298799466, 302061268, 305322360, 308582733, 311842381,
			315101294, 318359466, 321616889, 324873555, 328129456, 331384586, 334638935, 337892497, 341145265, 344397229, 347648383, 350898719, 354148229, 357396906, 360644742, 363891729,
			367137860, 370383127, 373627522, 376871039, 380113668, 383355403, 386596236, 389836160, 393075166, 396313247, 399550395, 402786603, 406021864, 409256169, 412489511, 415721883,
			418953276, 422183683, 425413097, 428641510, 431868914, 435095302, 438320666, 441544999, 444768293, 447990540, 451211733, 454431865, 457650927, 460868912, 464085812, 467301621,
			470516330, 473729932, 476942419, 480153783, 483364018, 486573116, 489781068, 492987869, 496193509, 499397981, 502601278, 505803393, 509004317, 512204044, 515402565, 518599874,
			521795962, 524990823, 528184448, 531376830, 534567962, 537757836, 540946445, 544133780, 547319836, 550504603, 553688075, 556870244, 560051103, 563230644, 566408859, 569585742,
			572761285, 575935479, 579108319, 582279796, 585449902, 588618631, 591785975, 594951926, 598116478, 601279622, 604441351, 607601658, 610760535, 613917975, 617073970, 620228513,
			623381597, 626533214, 629683356, 632832017, 635979189, 639124864, 642269036, 645411696, 648552837, 651692452, 654830534, 657967075, 661102067, 664235504, 667367378, 670497682,
			673626407, 676753548, 679879096, 683003045, 686125386, 689246113, 692365217, 695482693, 698598532, 701712727, 704825271, 707936157, 711045377, 714152923, 717258789, 720362967,
			723465451, 726566231, 729665302, 732762657, 735858286, 738952185, 742044344, 745134758, 748223418, 751310317, 754395449, 757478805, 760560379, 763640163, 766718150, 769794333,
			772868705, 775941258, 779011985, 782080880, 785147933, 788213140, 791276491, 794337981, 797397601, 800455345, 803511206, 806565176, 809617248, 812667415, 815715669, 818762004,
			821806412, 824848887, 827889421, 830928006, 833964637, 836999305, 840032003, 843062725, 846091463, 849118210, 852142958, 855165702, 858186434, 861205146, 864221831, 867236483,
			870249094, 873259658, 876268167, 879274613, 882278991, 885281292, 888281511, 891279639, 894275670, 897269597, 900261412, 903251109, 906238680, 909224119, 912207418, 915188571,
			918167571, 921144410, 924119081, 927091578, 930061893, 933030020, 935995951, 938959680, 941921199, 944880502, 947837581, 950792430, 953745042, 956695410, 959643526, 962589384,
			965532977, 968474299, 971413341, 974350097, 977284561, 980216725, 983146582, 986074126, 988999350, 991922247, 994842809, 997761030, 1000676904, 1003590423, 1006501580, 1009410369,
			1012316783, 1015220815, 1018122458, 1021021705, 1023918549, 1026812984, 1029705003, 1032594599, 1035481765, 1038366494, 1041248781, 1044128616, 1047005996, 1049880911, 1052753356, 1055623323,
			1058490807, 1061355800, 1064218295, 1067078287, 1069935767, 1072790729, 1075643168, 1078493075, 1081340444, 1084185269, 1087027543, 1089867258, 1092704410, 1095538990, 1098370992, 1101200409,
			1104027236, 1106851464, 1109673088, 1112492100, 1115308495, 1118122266, 1120933405, 1123741907, 1126547764, 1129350971, 1132151520, 1134949405, 1137744620, 1140537157, 1143327010, 1146114173,
			1148898639, 1151680402, 1154459455, 1157235791, 1160009404, 1162780287, 1165548434, 1168313839, 1171076494, 1173836394, 1176593532, 1179347901, 1182099495, 1184848307, 1187594331, 1190337561,
			1193077990, 1195815611, 1198550418, 1201282406, 1204011566, 1206737893, 1209461381, 1212182022, 1214899812, 1217614742, 1220326808, 1223036001, 1225742317, 1228445749, 1231146290, 1233843934,
			1236538674, 1239230505, 1241919420, 1244605413, 1247288476, 1249968605, 1252645793, 1255320033, 1257991319, 1260659645, 1263325004, 1265987391, 1268646799, 1271303221, 1273956652, 1276607085,
			1279254514, 1281898933, 1284540336, 1287178716, 1289814067, 1292446383, 1295075658, 1297701885, 1300325059, 1302945173, 1305562221, 1308176197, 1310787094, 1313394908, 1315999630, 1318601256,
			1321199779, 1323795194, 1326387493, 1328976671, 1331562722, 1334145640, 1336725418, 1339302051, 1341875532, 1344445856, 1347013016, 1349577006, 1352137821, 1354695454, 1357249900, 1359801151,
			1362349203, 1364894049, 1367435684, 1369974100, 1372509293, 1375041257, 1377569984, 1380095471, 1382617709, 1385136695, 1387652420, 1390164881, 1392674071, 1395179983, 1397682612, 1400181953,
			1402677998, 1405170743, 1407660182, 1410146308, 1412629116, 1415108600, 1417584754, 1420057573, 1422527049, 1424993179, 1427455955, 1429915373, 1432371425, 1434824107, 1437273413, 1439719337,
			1442161873, 1444601016, 1447036759, 1449469097, 1451898024, 1454323535, 1456745624, 1459164285, 1461579512, 1463991301, 1466399644, 1468804536, 1471205973, 1473603947, 1475998454, 1478389488,
			1480777043, 1483161114, 1485541694, 1487918779, 1490292363, 1492662440, 1495029005, 1497392051, 1499751575, 1502107569, 1504460028, 1506808947, 1509154321, 1511496144, 1513834409, 1516169113,
			1518500249, 1520827811, 1523151796, 1525472195, 1527789006, 1530102221, 1532411836, 1534717845, 1537020242, 1539319023, 1541614182, 1543905713, 1546193611, 1548477871, 1550758487, 1553035454,
			1555308767, 1557578419, 1559844407, 1562106724, 1564365365, 1566620326, 1568871600, 1571119182, 1573363067, 1575603250, 1577839725, 1580072488, 1582301532, 1584526853, 1586748446, 1588966305,
			1591180424, 1593390800, 1595597426, 1597800298, 1599999410, 1602194757, 1604386334, 1606574135, 1608758156, 1610938392, 1613114836, 1615287485, 1617456334, 1619621376, 1621782607, 1623940021,
			1626093615, 1628243382, 1630389317, 1632531417, 1634669674, 1636804086, 1638934645, 1641061348, 1643184190, 1645303165, 1647418268, 1649529495, 1651636840, 1653740299, 1655839866, 1657935537,
			1660027307, 1662115171, 1664199123, 1666279160, 1668355275, 1670427465, 1672495724, 1674560047, 1676620430, 1678676868, 1680729356, 1682777889, 1684822462, 1686863071, 1688899710, 1690932375,
			1692961061, 1694985763, 1697006477, 1699023198, 1701035921, 1703044641, 1705049354, 1707050054, 1709046738, 1711039400, 1713028036, 1715012641, 1716993210, 1718969739, 1720942223, 1722910658,
			1724875039, 1726835360, 1728791618, 1730743809, 1732691926, 1734635967, 1736575926, 1738511798, 1740443579, 1742371265, 1744294851, 1746214333, 1748129706, 1750040965, 1751948106, 1753851124,
			1755750016, 1757644776, 1759535400, 1761421884, 1763304223, 1765182413, 1767056449, 1768926327, 1770792043, 1772653592, 1774510969, 1776364171, 1778213193, 1780058031, 1781898680, 1783735136,
			1785567395, 1787395452, 1789219303, 1791038944, 1792854371, 1794665579, 1796472564, 1798275321, 1800073847, 1801868137, 1803658188, 1805443994, 1807225552, 1809002857, 1810775905, 1812544693,
			1814309215, 1816069468, 1817825448, 1819577150, 1821324571, 1823067705, 1824806550, 1826541101, 1828271354, 1829997305, 1831718950, 1833436285, 1835149305, 1836858007, 1838562387, 1840262440,
			1841958163, 1843649552, 1845336602, 1847019310, 1848697672, 1850371684, 1852041342, 1853706642, 1855367579, 1857024151, 1858676353, 1860324182, 1861967633, 1863606703, 1865241387, 1866871682,
			1868497584, 1870119090, 1871736195, 1873348896, 1874957188, 1876561068, 1878160533, 1879755578, 1881346200, 1882932395, 1884514160, 1886091490, 1887664381, 1889232831, 1890796835, 1892356390,
			1893911493, 1895462138, 1897008324, 1898550045, 1900087299, 1901620082, 1903148391, 1904672221, 1906191569, 1907706431, 1909216805, 1910722686, 1912224071, 1913720956, 1915213339, 1916701214,
			1918184579, 1919663431, 1921137766, 1922607579, 1924072869, 1925533631, 1926989863, 1928441559, 1929888719, 1931331336, 1932769410, 1934202935, 1935631909, 1937056328, 1938476189, 1939891489,
			1941302224, 1942708390, 1944109986, 1945507007, 1946899449, 1948287311, 1949670588, 1951049277, 1952423376, 1953792880, 1955157786, 1956518092, 1957873794, 1959224889, 1960571374, 1961913245,
			1963250500, 1964583135, 1965911147, 1967234533, 1968553290, 1969867415, 1971176905, 1972481756, 1973781966, 1975077531, 1976368449, 1977654716, 1978936329, 1980213286, 1981485584, 1982753218,
			1984016187, 1985274488, 1986528117, 1987777071, 1989021348, 1990260945, 1991495858, 1992726085, 1993951623, 1995172470, 1996388621, 1997600075, 1998806828, 2000008877, 2001206221, 2002398855,
			2003586778, 2004769986, 2005948476, 2007122247, 2008291294, 2009455616, 2010615209, 2011770071, 2012920199, 2014065591, 2015206243, 2016342154, 2017473319, 2018599738, 2019721406, 2020838322,
			2021950482, 2023057885, 2024160527, 2025258407, 2026351520, 2027439866, 2028523440, 2029602242, 2030676267, 2031745514, 2032809981, 2033869663, 2034924560, 2035974669, 2037019987, 2038060511,
			2039096240, 2040127170, 2041153300, 2042174627, 2043191148, 2044202862, 2045209765, 2046211856, 2047209132, 2048201590, 2049189229, 2050172046, 2051150039, 2052123205, 2053091543, 2054055049,
			2055013722, 2055967559, 2056916558, 2057860717, 2058800034, 2059734506, 2060664132, 2061588909, 2062508834, 2063423906, 2064334123, 2065239482, 2066139982, 2067035619, 2067926393, 2068812301,
			2069693340, 2070569510, 2071440807, 2072307229, 2073168776, 2074025444, 2074877232, 2075724137, 2076566158, 2077403293, 2078235539, 2079062895, 2079885359, 2080702928, 2081515602, 2082323377,
			2083126253, 2083924227, 2084717297, 2085505461, 2086288718, 2087067066, 2087840503, 2088609027, 2089372636, 2090131329, 2090885104, 2091633958, 2092377891, 2093116900, 2093850983, 2094580140,
			2095304368, 2096023666, 2096738031, 2097447462, 2098151959, 2098851517, 2099546137, 2100235817, 2100920555, 2101600349, 2102275197, 2102945099, 2103610052, 2104270056, 2104925108, 2105575206,
			2106220350, 2106860538, 2107495769, 2108126040, 2108751350, 2109371699, 2109987084, 2110597504, 2111202957, 2111803443, 2112398959, 2112989505, 2113575078, 2114155678, 2114731304, 2115301953,
			2115867624, 2116428317, 2116984030, 2117534761, 2118080509, 2118621274, 2119157053, 2119687845, 2120213650, 2120734465, 2121250290, 2121761124, 2122266965, 2122767812, 2123263664, 2123754520,
			2124240379, 2124721239, 2125197099, 2125667958, 2126133816, 2126594670, 2127050521, 2127501366, 2127947205, 2128388037, 2128823860, 2129254674, 2129680478, 2130101271, 2130517051, 2130927817,
			2131333570, 2131734307, 2132130028, 2132520732, 2132906418, 2133287086, 2133662733, 2134033359, 2134398964, 2134759547, 2135115106, 2135465641, 2135811151, 2136151635, 2136487093, 2136817524,
			2137142926, 2137463299, 2137778643, 2138088956, 2138394238, 2138694489, 2138989706, 2139279891, 2139565041, 2139845157, 2140120238, 2140390283, 2140655291, 2140915262, 2141170196, 2141420091,
			2141664947, 2141904763, 2142139539, 2142369275, 2142593969, 2142813622, 2143028233, 2143237800, 2143442325, 2143641805, 2143836242, 2144025634, 2144209981, 2144389282, 2144563537, 2144732746,
			2144896908, 2145056023, 2145210091, 2145359111, 2145503082, 2145642005, 2145775879, 2145904703, 2146028478, 2146147204, 2146260879, 2146369504, 2146473078, 2146571602, 2146665074, 2146753495,
			2146836865, 2146915182, 2146988448, 2147056662, 2147119824, 2147177933, 2147230990, 2147278994, 2147321945, 2147359843, 2147392689, 2147420481, 2147443221, 2147460907, 2147473540, 2147481120,
			2147483647, 2147481120, 2147473540, 2147460907, 2147443221, 2147420481, 2147392689, 2147359843, 2147321945, 2147278994, 2147230990, 2147177933, 2147119824, 2147056662, 2146988448, 2146915182,
			2146836865, 2146753495, 2146665074, 2146571602, 2146473078, 2146369504, 2146260879, 2146147204, 2146028478, 2145904703, 2145775879, 2145642005, 2145503082, 2145359111, 2145210091, 2145056023,
			2144896908, 2144732746, 2144563537, 2144389282, 2144209981, 2144025634, 2143836242, 2143641805, 2143442325, 2143237800, 2143028233, 2142813622, 2142593969, 2142369275, 2142139539, 2141904763,
			2141664947, 2141420091, 2141170196, 2140915262, 2140655291, 2140390283, 2140120238, 2139845157, 2139565041, 2139279891, 2138989706, 2138694489, 2138394238, 2138088956, 2137778643, 2137463299,
			2137142926, 2136817524, 2136487093, 2136151635, 2135811151, 2135465641, 2135115106, 2134759547, 2134398964, 2134033359, 2133662733, 2133287086, 2132906418, 2132520732, 2132130028, 2131734307,
			2131333570, 2130927817, 2130517051, 2130101271, 2129680478, 2129254674, 2128823860, 2128388037, 2127947205, 2127501366, 2127050521, 2126594670, 2126133816, 2125667958, 2125197099, 2124721239,
			2124240379, 2123754520, 2123263664, 2122767812, 2122266965, 2121761124, 2121250290, 2120734465, 2120213650, 2119687845, 2119157053, 2118621274, 2118080509, 2117534761, 2116984030, 2116428317,
			2115867624, 2115301953, 2114731304, 2114155678, 2113575078, 2112989505, 2112398959, 2111803443, 2111202957, 2110597504, 2109987084, 2109371699, 2108751350, 2108126040, 2107495769, 2106860538,
			2106220350, 2105575206, 2104925108, 2104270056, 2103610052, 2102945099, 2102275197, 2101600349, 2100920555, 2100235817, 2099546137, 2098851517, 2098151959, 2097447462, 2096738031, 2096023666,
			2095304368, 2094580140, 2093850983, 2093116900, 2092377891, 2091633958, 2090885104, 2090131329, 2089372636, 2088609027, 2087840503, 2087067066, 2086288718, 2085505461, 2084717297, 2083924227,
			2083126253, 2082323377, 2081515602, 2080702928, 2079885359, 2079062895, 2078235539, 2077403293, 2076566158, 2075724137, 2074877232, 2074025444, 2073168776, 2072307229, 2071440807, 2070569510,
			2069693340, 2068812301, 2067926393, 2067035619, 2066139982, 2065239482, 2064334123, 2063423906, 2062508834, 2061588909, 2060664132, 2059734506, 2058800034, 2057860717, 2056916558, 2055967559,
			2055013722, 2054055049, 2053091543, 2052123205, 2051150039, 2050172046, 2049189229, 2048201590, 2047209132, 2046211856, 2045209765, 2044202862, 2043191148, 2042174627, 2041153300, 2040127170,
			2039096240, 2038060511, 2037019987, 2035974669, 2034924560, 2033869663, 2032809981, 2031745514, 2030676267, 2029602242, 2028523440, 2027439866, 2026351520, 2025258407, 2024160527, 2023057885,
			2021950482, 2020838322, 2019721406, 2018599738, 2017473319, 2016342154, 2015206243, 2014065591, 2012920199, 2011770071, 2010615209, 2009455616, 2008291294, 2007122247, 2005948476, 2004769986,
			2003586778, 2002398855, 2001206221, 2000008877, 1998806828, 1997600075, 1996388621, 1995172470, 1993951623, 1992726085, 1991495858, 1990260945, 1989021348, 1987777071, 1986528117, 1985274488,
			1984016187, 1982753218, 1981485584, 1980213286, 1978936329, 1977654716, 1976368449, 1975077531, 1973781966, 1972481756, 1971176905, 1969867415, 1968553290, 1967234533, 1965911147, 1964583135,
			1963250500, 1961913245, 1960571374, 1959224889, 1957873794, 1956518092, 1955157786, 1953792880, 1952423376, 1951049277, 1949670588, 1948287311, 1946899449, 1945507007, 1944109986, 1942708390,
			1941302224, 1939891489, 1938476189, 1937056328, 1935631909, 1934202935, 1932769410, 1931331336, 1929888719, 1928441559, 1926989863, 1925533631, 1924072869, 1922607579, 1921137766, 1919663431,
			1918184579, 1916701214, 1915213339, 1913720956, 1912224071, 1910722686, 1909216805, 1907706431, 1906191569, 1904672221, 1903148391, 1901620082, 1900087299, 1898550045, 1897008324, 1895462138,
			1893911493, 1892356390, 1890796835, 1889232831, 1887664381, 1886091490, 1884514160, 1882932395, 1881346200, 1879755578, 1878160533, 1876561068, 1874957188, 1873348896, 1871736195, 1870119090,
			1868497584, 1866871682, 1865241387, 1863606703, 1861967633, 1860324182, 1858676353, 1857024151, 1855367579, 1853706642, 1852041342, 1850371684, 1848697672, 1847019310, 1845336602, 1843649552,
			1841958163, 1840262440, 1838562387, 1836858007, 1835149305, 1833436285, 1831718950, 1829997305, 1828271354, 1826541101, 1824806550, 1823067705, 1821324571, 1819577150, 1817825448, 1816069468,
			1814309215, 1812544693, 1810775905, 1809002857, 1807225552, 1805443994, 1803658188, 1801868137, 1800073847, 1798275321, 1796472564, 1794665579, 1792854371, 1791038944, 1789219303, 1787395452,
			1785567395, 1783735136, 1781898680, 1780058031, 1778213193, 1776364171, 1774510969, 1772653592, 1770792043, 1768926327, 1767056449, 1765182413, 1763304223, 1761421884, 1759535400, 1757644776,
			1755750016, 1753851124, 1751948106, 1750040965, 1748129706, 1746214333, 1744294851, 1742371265, 1740443579, 1738511798, 1736575926, 1734635967, 1732691926, 1730743809, 1728791618, 1726835360,
			1724875039, 1722910658, 1720942223, 1718969739, 1716993210, 1715012641, 1713028036, 1711039400, 1709046738, 1707050054, 1705049354, 1703044641, 1701035921, 1699023198, 1697006477, 1694985763,
			1692961061, 1690932375, 1688899710, 1686863071, 1684822462, 1682777889, 1680729356, 1678676868, 1676620430, 1674560047, 1672495724, 1670427465, 1668355275, 1666279160, 1664199123, 1662115171,
			1660027307, 1657935537, 1655839866, 1653740299, 1651636840, 1649529495, 1647418268, 1645303165, 1643184190, 1641061348, 1638934645, 1636804086, 1634669674, 1632531417, 1630389317, 1628243382,
			1626093615, 1623940021, 1621782607, 1619621376, 1617456334, 1615287485, 1613114836, 1610938392, 1608758156, 1606574135, 1604386334, 1602194757, 1599999410, 1597800298, 1595597426, 1593390800,
			1591180424, 1588966305, 1586748446, 1584526853, 1582301532, 1580072488, 1577839725, 1575603250, 1573363067, 1571119182, 1568871600, 1566620326, 1564365365, 1562106724, 1559844407, 1557578419,
			1555308767, 1553035454, 1550758487, 1548477871, 1546193611, 1543905713, 1541614182, 1539319023, 1537020242, 1534717845, 1532411836, 1530102221, 1527789006, 1525472195, 1523151796, 1520827811,
			1518500249, 1516169113, 1513834409, 1511496144, 1509154321, 1506808947, 1504460028, 1502107569, 1499751575, 1497392051, 1495029005, 1492662440, 1490292363, 1487918779, 1485541694, 1483161114,
			1480777043, 1478389488, 1475998454, 1473603947, 1471205973, 1468804536, 1466399644, 1463991301, 1461579512, 1459164285, 1456745624, 1454323535, 1451898024, 1449469097, 1447036759, 1444601016,
			1442161873, 1439719337, 1437273413, 1434824107, 1432371425, 1429915373, 1427455955, 1424993179, 1422527049, 1420057573, 1417584754, 1415108600, 1412629116, 1410146308, 1407660182, 1405170743,
			1402677998, 1400181953, 1397682612, 1395179983, 1392674071, 1390164881, 1387652420, 1385136695, 1382617709, 1380095471, 1377569984, 1375041257, 1372509293, 1369974100, 1367435684, 1364894049,
			1362349203, 1359801151, 1357249900, 1354695454, 1352137821, 1349577006, 1347013016, 1344445856, 1341875532, 1339302051, 1336725418, 1334145640, 1331562722, 1328976671, 1326387493, 1323795194,
			1321199779, 1318601256, 1315999630, 1313394908, 1310787094, 1308176197, 1305562221, 1302945173, 1300325059, 1297701885, 1295075658, 1292446383, 1289814067, 1287178716, 1284540336, 1281898933,
			1279254514, 1276607085, 1273956652, 1271303221, 1268646799, 1265987391, 1263325004, 1260659645, 1257991319, 1255320033, 1252645793, 1249968605, 1247288476, 1244605413, 1241919420, 1239230505,
			1236538674, 1233843934, 1231146290, 1228445749, 1225742317, 1223036001, 1220326808, 1217614742, 1214899812, 1212182022, 1209461381, 1206737893, 1204011566, 1201282406, 1198550418, 1195815611,
			1193077990, 1190337561, 1187594331, 1184848307, 1182099495, 1179347901, 1176593532, 1173836394, 1171076494, 1168313839, 1165548434, 1162780287, 1160009404, 1157235791, 1154459455, 1151680402,
			1148898639, 1146114173, 1143327010, 1140537157, 1137744620, 1134949405, 1132151520, 1129350971, 1126547764, 1123741907, 1120933405, 1118122266, 1115308495, 1112492100, 1109673088, 1106851464,
			1104027236, 1101200409, 1098370992, 1095538990, 1092704410, 1089867258, 1087027543, 1084185269, 1081340444, 1078493075, 1075643168, 1072790729, 1069935767, 1067078287, 1064218295, 1061355800,
			1058490807, 1055623323, 1052753356, 1049880911, 1047005996, 1044128616, 1041248781, 1038366494, 1035481765, 1032594599, 1029705003, 1026812984, 1023918549, 1021021705, 1018122458, 1015220815,
			1012316783, 1009410369, 1006501580, 1003590423, 1000676904, 997761030, 994842809, 991922247, 988999350, 986074126, 983146582, 980216725, 977284561, 974350097, 971413341, 968474299,
			965532977, 962589384, 959643526, 956695410, 953745042, 950792430, 947837581, 944880502, 941921199, 938959680, 935995951, 933030020, 930061893, 927091578, 924119081, 921144410,
			918167571, 915188571, 912207418, 909224119, 906238680, 903251109, 900261412, 897269597, 894275670, 891279639, 888281511, 885281292, 882278991, 879274613, 876268167, 873259658,
			870249094, 867236483, 864221831, 861205146, 858186434, 855165702, 852142958, 849118210, 846091463, 843062725, 840032003, 836999305, 833964637, 830928006, 827889421, 824848887,
			821806412, 818762004, 815715669, 812667415, 809617248, 806565176, 803511206, 800455345, 797397601, 794337981, 791276491, 788213140, 785147933, 782080880, 779011985, 775941258,
			772868705, 769794333, 766718150, 763640163, 760560379, 757478805, 754395449, 751310317, 748223418, 745134758, 742044344, 738952185, 735858286, 732762657, 729665302, 726566231,
			723465451, 720362967, 717258789, 714152923, 711045377, 707936157, 704825271, 701712727, 698598532, 695482693, 692365217, 689246113, 686125386, 683003045, 679879096, 676753548,
			673626407, 670497682, 667367378, 664235504, 661102067, 657967075, 654830534, 651692452, 648552837, 645411696, 642269036, 639124864, 635979189, 632832017, 629683356, 626533214,
			623381597, 620228513, 617073970, 613917975, 610760535, 607601658, 604441351, 601279622, 598116478, 594951926, 591785975, 588618631, 585449902, 582279796, 579108319, 575935479,
			572761285, 569585742, 566408859, 563230644, 560051103, 556870244, 553688075, 550504603, 547319836, 544133780, 540946445, 537757836, 534567962, 531376830, 528184448, 524990823,
			521795962, 518599874, 515402565, 512204044, 509004317, 505803393, 502601278, 499397981, 496193509, 492987869, 489781068, 486573116, 483364018, 480153783, 476942419, 473729932,
			470516330, 467301621, 464085812, 460868912, 457650927, 454431865, 451211733, 447990540, 444768293, 441544999, 438320666, 435095302, 431868914, 428641510, 425413097, 422183683,
			418953276, 415721883, 412489511, 409256169, 406021864, 402786603, 399550395, 396313247, 393075166, 389836160, 386596236, 383355403, 380113668, 376871039, 373627522, 370383127,
			367137860, 363891729, 360644742, 357396906, 354148229, 350898719, 347648383, 344397229, 341145265, 337892497, 334638935, 331384586, 328129456, 324873555, 321616889, 318359466,
			315101294, 311842381, 308582733, 305322360, 302061268, 298799466, 295536960, 292273759, 289009870, 285745301, 282480060, 279214154, 275947591, 272680379, 269412525, 266144037,
			262874923, 259605190, 256334846, 253063900, 249792357, 246520227, 243247517, 239974234, 236700387, 233425983, 230151030, 226875534, 223599506, 220322950, 217045877, 213768293,
			210490205, 207211623, 203932553, 200653003, 197372981, 194092494, 190811551, 187530158, 184248325, 180966058, 177683365, 174400253, 171116732, 167832808, 164548489, 161263783,
			157978697, 154693239, 151407418, 148121240, 144834714, 141547847, 138260647, 134973121, 131685278, 128397125, 125108670, 121819920, 118530884, 115241569, 111951983, 108662133,
			105372028, 102081674, 98791081, 95500255, 92209204, 88917936, 85626459, 82334781, 79042909, 75750851, 72458614, 69166207, 65873638, 62580913, 59288041, 55995030,
			52701886, 49408619, 46115236, 42821744, 39528151, 36234465, 32940694, 29646846, 26352927, 23058947, 19764912, 16470831, 13176711, 9882561, 6588386, 3294197,
			0, -3294197, -6588386, -9882561, -13176711, -16470831, -19764912, -23058947, -26352927, -29646846, -32940694, -36234465, -39528151, -42821744, -46115236, -49408619,
			-52701886, -55995030, -59288041, -62580913, -65873638, -69166207, -72458614, -75750851, -79042909, -82334781, -85626459, -88917936, -92209204, -95500255, -98791081, -102081674,
			-105372028, -108662133, -111951983, -115241569, -118530884, -121819920, -125108670, -128397125, -131685278, -134973121, -138260647, -141547847, -144834714, -148121240, -151407418, -154693239,
			-157978697, -161263783, -164548489, -167832808, -171116732, -174400253, -177683365, -180966058, -184248325, -187530158, -190811551, -194092494, -197372981, -200653003, -203932553, -207211623,
			-210490205, -213768293, -217045877, -220322950, -223599506, -226875534, -230151030, -233425983, -236700387, -239974234, -243247517, -246520227, -249792357, -253063900, -256334846, -259605190,
			-262874923, -266144037, -269412525, -272680379, -275947591, -279214154, -282480060, -285745301, -289009870, -292273759, -295536960, -298799466, -302061268, -305322360, -308582733, -311842381,
			-315101294, -318359466, -321616889, -324873555, -328129456, -331384586, -334638935, -337892497, -341145265, -344397229, -347648383, -350898719, -354148229, -357396906, -360644742, -363891729,
			-367137860, -370383127, -373627522, -376871039, -380113668, -383355403, -386596236, -389836160, -393075166, -396313247, -399550395, -402786603, -406021864, -409256169, -412489511, -415721883,
			-418953276, -422183683, -425413097, -428641510, -431868914, -435095302, -438320666, -441544999, -444768293, -447990540, -451211733, -454431865, -457650927, -460868912, -464085812, -467301621,
			-470516330, -473729932, -476942419, -480153783, -483364018, -486573116, -489781068, -492987869, -496193509, -499397981, -502601278, -505803393, -509004317, -512204044, -515402565, -518599874,
			-521795962, -524990823, -528184448, -531376830, -534567962, -537757836, -540946445, -544133780, -547319836, -550504603, -553688075, -556870244, -560051103, -563230644, -566408859, -569585742,
			-572761285, -575935479, -579108319, -582279796, -585449902, -588618631, -591785975, -594951926, -598116478, -601279622, -604441351, -607601658, -610760535, -613917975, -617073970, -620228513,
			-623381597, -626533214, -629683356, -632832017, -635979189, -639124864, -642269036, -645411696, -648552837, -651692452, -654830534, -657967075, -661102067, -664235504, -667367378, -670497682,
			-673626407, -676753548, -679879096, -683003045, -686125386, -689246113, -692365217, -695482693, -698598532, -701712727, -704825271, -707936157, -711045377, -714152923, -717258789, -720362967,
			-723465451, -726566231, -729665302, -732762657, -735858286, -738952185, -742044344, -745134758, -748223418, -751310317, -754395449, -757478805, -760560379, -763640163, -766718150, -769794333,
			-772868705, -775941258, -779011985, -782080880, -785147933, -788213140, -791276491, -794337981, -797397601, -800455345, -803511206, -806565176, -809617248, -812667415, -815715669, -818762004,
			-821806412, -824848887, -827889421, -830928006, -833964637, -836999305, -840032003, -843062725, -846091463, -849118210, -852142958, -855165702, -858186434, -861205146, -864221831, -867236483,
			-870249094, -873259658, -876268167, -879274613, -882278991, -885281292, -888281511, -891279639, -894275670, -897269597, -900261412, -903251109, -906238680, -909224119, -912207418, -915188571,
			-918167571, -921144410, -924119081, -927091578, -930061893, -933030020, -935995951, -938959680, -941921199, -944880502, -947837581, -950792430, -953745042, -956695410, -959643526, -962589384,
			-965532977, -968474299, -971413341, -974350097, -977284561, -980216725, -983146582, -986074126, -988999350, -991922247, -994842809, -997761030, -1000676904, -1003590423, -1006501580, -1009410369,
			-1012316783, -1015220815, -1018122458, -1021021705, -1023918549, -1026812984, -1029705003, -1032594599, -1035481765, -1038366494, -1041248781, -1044128616, -1047005996, -1049880911, -1052753356, -1055623323,
			-1058490807, -1061355800, -1064218295, -1067078287, -1069935767, -1072790729, -1075643168, -1078493075, -1081340444, -1084185269, -1087027543, -1089867258, -1092704410, -1095538990, -1098370992, -1101200409,
			-1104027236, -1106851464, -1109673088, -1112492100, -1115308495, -1118122266, -1120933405, -1123741907, -1126547764, -1129350971, -1132151520, -1134949405, -1137744620, -1140537157, -1143327010, -1146114173,
			-1148898639, -1151680402, -1154459455, -1157235791, -1160009404, -1162780287, -1165548434, -1168313839, -1171076494, -1173836394, -1176593532, -1179347901, -1182099495, -1184848307, -1187594331, -1190337561,
			-1193077990, -1195815611, -1198550418, -1201282406, -1204011566, -1206737893, -1209461381, -1212182022, -1214899812, -1217614742, -1220326808, -1223036001, -1225742317, -1228445749, -1231146290, -1233843934,
			-1236538674, -1239230505, -1241919420, -1244605413, -1247288476, -1249968605, -1252645793, -1255320033, -1257991319, -1260659645, -1263325004, -1265987391, -1268646799, -1271303221, -1273956652, -1276607085,
			-1279254514, -1281898933, -1284540336, -1287178716, -1289814067, -1292446383, -1295075658, -1297701885, -1300325059, -1302945173, -1305562221, -1308176197, -1310787094, -1313394908, -1315999630, -1318601256,
			-1321199779, -1323795194, -1326387493, -1328976671, -1331562722, -1334145640, -1336725418, -1339302051, -1341875532, -1344445856, -1347013016, -1349577006, -1352137821, -1354695454, -1357249900, -1359801151,
			-1362349203, -1364894049, -1367435684, -1369974100, -1372509293, -1375041257, -1377569984, -1380095471, -1382617709, -1385136695, -1387652420, -1390164881, -1392674071, -1395179983, -1397682612, -1400181953,
			-1402677998, -1405170743, -1407660182, -1410146308, -1412629116, -1415108600, -1417584754, -1420057573, -1422527049, -1424993179, -1427455955, -1429915373, -1432371425, -1434824107, -1437273413, -1439719337,
			-1442161873, -1444601016, -1447036759, -1449469097, -1451898024, -1454323535, -1456745624, -1459164285, -1461579512, -1463991301, -1466399644, -1468804536, -1471205973, -1473603947, -1475998454, -1478389488,
			-1480777043, -1483161114, -1485541694, -1487918779, -1490292363, -1492662440, -1495029005, -1497392051, -1499751575, -1502107569, -1504460028, -1506808947, -1509154321, -1511496144, -1513834409, -1516169113,
			-1518500249, -1520827811, -1523151796, -1525472195, -1527789006, -1530102221, -1532411836, -1534717845, -1537020242, -1539319023, -1541614182, -1543905713, -1546193611, -1548477871, -1550758487, -1553035454,
			-1555308767, -1557578419, -1559844407, -1562106724, -1564365365, -1566620326, -1568871600, -1571119182, -1573363067, -1575603250, -1577839725, -1580072488, -1582301532, -1584526853, -1586748446, -1588966305,
			-1591180424, -1593390800, -1595597426, -1597800298, -1599999410, -1602194757, -1604386334, -1606574135, -1608758156, -1610938392, -1613114836, -1615287485, -1617456334, -1619621376, -1621782607, -1623940021,
			-1626093615, -1628243382, -1630389317, -1632531417, -1634669674, -1636804086, -1638934645, -1641061348, -1643184190, -1645303165, -1647418268, -1649529495, -1651636840, -1653740299, -1655839866, -1657935537,
			-1660027307, -1662115171, -1664199123, -1666279160, -1668355275, -1670427465, -1672495724, -1674560047, -1676620430, -1678676868, -1680729356, -1682777889, -1684822462, -1686863071, -1688899710, -1690932375,
			-1692961061, -1694985763, -1697006477, -1699023198, -1701035921, -1703044641, -1705049354, -1707050054, -1709046738, -1711039400, -1713028036, -1715012641, -1716993210, -1718969739, -1720942223, -1722910658,
			-1724875039, -1726835360, -1728791618, -1730743809, -1732691926, -1734635967, -1736575926, -1738511798, -1740443579, -1742371265, -1744294851, -1746214333, -1748129706, -1750040965, -1751948106, -1753851124,
			-1755750016, -1757644776, -1759535400, -1761421884, -1763304223, -1765182413, -1767056449, -1768926327, -1770792043, -1772653592, -1774510969, -1776364171, -1778213193, -1780058031, -1781898680, -1783735136,
			-1785567395, -1787395452, -1789219303, -1791038944, -1792854371, -1794665579, -1796472564, -1798275321, -1800073847, -1801868137, -1803658188, -1805443994, -1807225552, -1809002857, -1810775905, -1812544693,
			-1814309215, -1816069468, -1817825448, -1819577150, -1821324571, -1823067705, -1824806550, -1826541101, -1828271354, -1829997305, -1831718950, -1833436285, -1835149305, -1836858007, -1838562387, -1840262440,
			-1841958163, -1843649552, -1845336602, -1847019310, -1848697672, -1850371684, -1852041342, -1853706642, -1855367579, -1857024151, -1858676353, -1860324182, -1861967633, -1863606703, -1865241387, -1866871682,
			-1868497584, -1870119090, -1871736195, -1873348896, -1874957188, -1876561068, -1878160533, -1879755578, -1881346200, -1882932395, -1884514160, -1886091490, -1887664381, -1889232831, -1890796835, -1892356390,
			-1893911493, -1895462138, -1897008324, -1898550045, -1900087299, -1901620082, -1903148391, -1904672221, -1906191569, -1907706431, -1909216805, -1910722686, -1912224071, -1913720956, -1915213339, -1916701214,
			-1918184579, -1919663431, -1921137766, -1922607579, -1924072869, -1925533631, -1926989863, -1928441559, -1929888719, -1931331336, -1932769410, -1934202935, -1935631909, -1937056328, -1938476189, -1939891489,
			-1941302224, -1942708390, -1944109986, -1945507007, -1946899449, -1948287311, -1949670588, -1951049277, -1952423376, -1953792880, -1955157786, -1956518092, -1957873794, -1959224889, -1960571374, -1961913245,
			-1963250500, -1964583135, -1965911147, -1967234533, -1968553290, -1969867415, -1971176905, -1972481756, -1973781966, -1975077531, -1976368449, -1977654716, -1978936329, -1980213286, -1981485584, -1982753218,
			-1984016187, -1985274488, -1986528117, -1987777071, -1989021348, -1990260945, -1991495858, -1992726085, -1993951623, -1995172470, -1996388621, -1997600075, -1998806828, -2000008877, -2001206221, -2002398855,
			-2003586778, -2004769986, -2005948476, -2007122247, -2008291294, -2009455616, -2010615209, -2011770071, -2012920199, -2014065591, -2015206243, -2016342154, -2017473319, -2018599738, -2019721406, -2020838322,
			-2021950482, -2023057885, -2024160527, -2025258407, -2026351520, -2027439866, -2028523440, -2029602242, -2030676267, -2031745514, -2032809981, -2033869663, -2034924560, -2035974669, -2037019987, -2038060511,
			-2039096240, -2040127170, -2041153300, -2042174627, -2043191148, -2044202862, -2045209765, -2046211856, -2047209132, -2048201590, -2049189229, -2050172046, -2051150039, -2052123205, -2053091543, -2054055049,
			-2055013722, -2055967559, -2056916558, -2057860717, -2058800034, -2059734506, -2060664132, -2061588909, -2062508834, -2063423906, -2064334123, -2065239482, -2066139982, -2067035619, -2067926393, -2068812301,
			-2069693340, -2070569510, -2071440807, -2072307229, -2073168776, -2074025444, -2074877232, -2075724137, -2076566158, -2077403293, -2078235539, -2079062895, -2079885359, -2080702928, -2081515602, -2082323377,
			-2083126253, -2083924227, -2084717297, -2085505461, -2086288718, -2087067066, -2087840503, -2088609027, -2089372636, -2090131329, -2090885104, -2091633958, -2092377891, -2093116900, -2093850983, -2094580140,
			-2095304368, -2096023666, -2096738031, -2097447462, -2098151959, -2098851517, -2099546137, -2100235817, -2100920555, -2101600349, -2102275197, -2102945099, -2103610052, -2104270056, -2104925108, -2105575206,
			-2106220350, -2106860538, -2107495769, -2108126040, -2108751350, -2109371699, -2109987084, -2110597504, -2111202957, -2111803443, -2112398959, -2112989505, -2113575078, -2114155678, -2114731304, -2115301953,
			-2115867624, -2116428317, -2116984030, -2117534761, -2118080509, -2118621274, -2119157053, -2119687845, -2120213650, -2120734465, -2121250290, -2121761124, -2122266965, -2122767812, -2123263664, -2123754520,
			-2124240379, -2124721239, -2125197099, -2125667958, -2126133816, -2126594670, -2127050521, -2127501366, -2127947205, -2128388037, -2128823860, -2129254674, -2129680478, -2130101271, -2130517051, -2130927817,
			-2131333570, -2131734307, -2132130028, -2132520732, -2132906418, -2133287086, -2133662733, -2134033359, -2134398964, -2134759547, -2135115106, -2135465641, -2135811151, -2136151635, -2136487093, -2136817524,
			-2137142926, -2137463299, -2137778643, -2138088956, -2138394238, -2138694489, -2138989706, -2139279891, -2139565041, -2139845157, -2140120238, -2140390283, -2140655291, -2140915262, -2141170196, -2141420091,
			-2141664947, -2141904763, -2142139539, -2142369275, -2142593969, -2142813622, -2143028233, -2143237800, -2143442325, -2143641805, -2143836242, -2144025634, -2144209981, -2144389282, -2144563537, -2144732746,
			-2144896908, -2145056023, -2145210091, -2145359111, -2145503082, -2145642005, -2145775879, -2145904703, -2146028478, -2146147204, -2146260879, -2146369504, -2146473078, -2146571602, -2146665074, -2146753495,
			-2146836865, -2146915182, -2146988448, -2147056662, -2147119824, -2147177933, -2147230990, -2147278994, -2147321945, -2147359843, -2147392689, -2147420481, -2147443221, -2147460907, -2147473540, -2147481120,
			-2147483647, -2147481120, -2147473540, -2147460907, -2147443221, -2147420481, -2147392689, -2147359843, -2147321945, -2147278994, -2147230990, -2147177933, -2147119824, -2147056662, -2146988448, -2146915182,
			-2146836865, -2146753495, -2146665074, -2146571602, -2146473078, -2146369504, -2146260879, -2146147204, -2146028478, -2145904703, -2145775879, -2145642005, -2145503082, -2145359111, -2145210091, -2145056023,
			-2144896908, -2144732746, -2144563537, -2144389282, -2144209981, -2144025634, -2143836242, -2143641805, -2143442325, -2143237800, -2143028233, -2142813622, -2142593969, -2142369275, -2142139539, -2141904763,
			-2141664947, -2141420091, -2141170196, -2140915262, -2140655291, -2140390283, -2140120238, -2139845157, -2139565041, -2139279891, -2138989706, -2138694489, -2138394238, -2138088956, -2137778643, -2137463299,
			-2137142926, -2136817524, -2136487093, -2136151635, -2135811151, -2135465641, -2135115106, -2134759547, -2134398964, -2134033359, -2133662733, -2133287086, -2132906418, -2132520732, -2132130028, -2131734307,
			-2131333570, -2130927817, -2130517051, -2130101271, -2129680478, -2129254674, -2128823860, -2128388037, -2127947205, -2127501366, -2127050521, -2126594670, -2126133816, -2125667958, -2125197099, -2124721239,
			-2124240379, -2123754520, -2123263664, -2122767812, -2122266965, -2121761124, -2121250290, -2120734465, -2120213650, -2119687845, -2119157053, -2118621274, -2118080509, -2117534761, -2116984030, -2116428317,
			-2115867624, -2115301953, -2114731304, -2114155678, -2113575078, -2112989505, -2112398959, -2111803443, -2111202957, -2110597504, -2109987084, -2109371699, -2108751350, -2108126040, -2107495769, -2106860538,
			-2106220350, -2105575206, -2104925108, -2104270056, -2103610052, -2102945099, -2102275197, -2101600349, -2100920555, -2100235817, -2099546137, -2098851517, -2098151959, -2097447462, -2096738031, -2096023666,
			-2095304368, -2094580140, -2093850983, -2093116900, -2092377891, -2091633958, -2090885104, -2090131329, -2089372636, -2088609027, -2087840503, -2087067066, -2086288718, -2085505461, -2084717297, -2083924227,
			-2083126253, -2082323377, -2081515602, -2080702928, -2079885359, -2079062895, -2078235539, -2077403293, -2076566158, -2075724137, -2074877232, -2074025444, -2073168776, -2072307229, -2071440807, -2070569510,
			-2069693340, -2068812301, -2067926393, -2067035619, -2066139982, -2065239482, -2064334123, -2063423906, -2062508834, -2061588909, -2060664132, -2059734506, -2058800034, -2057860717, -2056916558, -2055967559,
			-2055013722, -2054055049, -2053091543, -2052123205, -2051150039, -2050172046, -2049189229, -2048201590, -2047209132, -2046211856, -2045209765, -2044202862, -2043191148, -2042174627, -2041153300, -2040127170,
			-2039096240, -2038060511, -2037019987, -2035974669, -2034924560, -2033869663, -2032809981, -2031745514, -2030676267, -2029602242, -2028523440, -2027439866, -2026351520, -2025258407, -2024160527, -2023057885,
			-2021950482, -2020838322, -2019721406, -2018599738, -2017473319, -2016342154, -2015206243, -2014065591, -2012920199, -2011770071, -2010615209, -2009455616, -2008291294, -2007122247, -2005948476, -2004769986,
			-2003586778, -2002398855, -2001206221, -2000008877, -1998806828, -1997600075, -1996388621, -1995172470, -1993951623, -1992726085, -1991495858, -1990260945, -1989021348, -1987777071, -1986528117, -1985274488,
			-1984016187, -1982753218, -1981485584, -1980213286, -1978936329, -1977654716, -1976368449, -1975077531, -1973781966, -1972481756, -1971176905, -1969867415, -1968553290, -1967234533, -1965911147, -1964583135,
			-1963250500, -1961913245, -1960571374, -1959224889, -1957873794, -1956518092, -1955157786, -1953792880, -1952423376, -1951049277, -1949670588, -1948287311, -1946899449, -1945507007, -1944109986, -1942708390,
			-1941302224, -1939891489, -1938476189, -1937056328, -1935631909, -1934202935, -1932769410, -1931331336, -1929888719, -1928441559, -1926989863, -1925533631, -1924072869, -1922607579, -1921137766, -1919663431,
			-1918184579, -1916701214, -1915213339, -1913720956, -1912224071, -1910722686, -1909216805, -1907706431, -1906191569, -1904672221, -1903148391, -1901620082, -1900087299, -1898550045, -1897008324, -1895462138,
			-1893911493, -1892356390, -1890796835, -1889232831, -1887664381, -1886091490, -1884514160, -1882932395, -1881346200, -1879755578, -1878160533, -1876561068, -1874957188, -1873348896, -1871736195, -1870119090,
			-1868497584, -1866871682, -1865241387, -1863606703, -1861967633, -1860324182, -1858676353, -1857024151, -1855367579, -1853706642, -1852041342, -1850371684, -1848697672, -1847019310, -1845336602, -1843649552,
			-1841958163, -1840262440, -1838562387, -1836858007, -1835149305, -1833436285, -1831718950, -1829997305, -1828271354, -1826541101, -1824806550, -1823067705, -1821324571, -1819577150, -1817825448, -1816069468,
			-1814309215, -1812544693, -1810775905, -1809002857, -1807225552, -1805443994, -1803658188, -1801868137, -1800073847, -1798275321, -1796472564, -1794665579, -1792854371, -1791038944, -1789219303, -1787395452,
			-1785567395, -1783735136, -1781898680, -1780058031, -1778213193, -1776364171, -1774510969, -1772653592, -1770792043, -1768926327, -1767056449, -1765182413, -1763304223, -1761421884, -1759535400, -1757644776,
			-1755750016, -1753851124, -1751948106, -1750040965, -1748129706, -1746214333, -1744294851, -1742371265, -1740443579, -1738511798, -1736575926, -1734635967, -1732691926, -1730743809, -1728791618, -1726835360,
			-1724875039, -1722910658, -1720942223, -1718969739, -1716993210, -1715012641, -1713028036, -1711039400, -1709046738, -1707050054, -1705049354, -1703044641, -1701035921, -1699023198, -1697006477, -1694985763,
			-1692961061, -1690932375, -1688899710, -1686863071, -1684822462, -1682777889, -1680729356, -1678676868, -1676620430, -1674560047, -1672495724, -1670427465, -1668355275, -1666279160, -1664199123, -1662115171,
			-1660027307, -1657935537, -1655839866, -1653740299, -1651636840, -1649529495, -1647418268, -1645303165, -1643184190, -1641061348, -1638934645, -1636804086, -1634669674, -1632531417, -1630389317, -1628243382,
			-1626093615, -1623940021, -1621782607, -1619621376, -1617456334, -1615287485, -1613114836, -1610938392, -1608758156, -1606574135, -1604386334, -1602194757, -1599999410, -1597800298, -1595597426, -1593390800,
			-1591180424, -1588966305, -1586748446, -1584526853, -1582301532, -1580072488, -1577839725, -1575603250, -1573363067, -1571119182, -1568871600, -1566620326, -1564365365, -1562106724, -1559844407, -1557578419,
			-1555308767, -1553035454, -1550758487, -1548477871, -1546193611, -1543905713, -1541614182, -1539319023, -1537020242, -1534717845, -1532411836, -1530102221, -1527789006, -1525472195, -1523151796, -1520827811,
			-1518500249, -1516169113, -1513834409, -1511496144, -1509154321, -1506808947, -1504460028, -1502107569, -1499751575, -1497392051, -1495029005, -1492662440, -1490292363, -1487918779, -1485541694, -1483161114,
			-1480777043, -1478389488, -1475998454, -1473603947, -1471205973, -1468804536, -1466399644, -1463991301, -1461579512, -1459164285, -1456745624, -1454323535, -1451898024, -1449469097, -1447036759, -1444601016,
			-1442161873, -1439719337, -1437273413, -1434824107, -1432371425, -1429915373, -1427455955, -1424993179, -1422527049, -1420057573, -1417584754, -1415108600, -1412629116, -1410146308, -1407660182, -1405170743,
			-1402677998, -1400181953, -1397682612, -1395179983, -1392674071, -1390164881, -1387652420, -1385136695, -1382617709, -1380095471, -1377569984, -1375041257, -1372509293, -1369974100, -1367435684, -1364894049,
			-1362349203, -1359801151, -1357249900, -1354695454, -1352137821, -1349577006, -1347013016, -1344445856, -1341875532, -1339302051, -1336725418, -1334145640, -1331562722, -1328976671, -1326387493, -1323795194,
			-1321199779, -1318601256, -1315999630, -1313394908, -1310787094, -1308176197, -1305562221, -1302945173, -1300325059, -1297701885, -1295075658, -1292446383, -1289814067, -1287178716, -1284540336, -1281898933,
			-1279254514, -1276607085, -1273956652, -1271303221, -1268646799, -1265987391, -1263325004, -1260659645, -1257991319, -1255320033, -1252645793, -1249968605, -1247288476, -1244605413, -1241919420, -1239230505,
			-1236538674, -1233843934, -1231146290, -1228445749, -1225742317, -1223036001, -1220326808, -1217614742, -1214899812, -1212182022, -1209461381, -1206737893, -1204011566, -1201282406, -1198550418, -1195815611,
			-1193077990, -1190337561, -1187594331, -1184848307, -1182099495, -1179347901, -1176593532, -1173836394, -1171076494, -1168313839, -1165548434, -1162780287, -1160009404, -1157235791, -1154459455, -1151680402,
			-1148898639, -1146114173, -1143327010, -1140537157, -1137744620, -1134949405, -1132151520, -1129350971, -1126547764, -1123741907, -1120933405, -1118122266, -1115308495, -1112492100, -1109673088, -1106851464,
			-1104027236, -1101200409, -1098370992, -1095538990, -1092704410, -1089867258, -1087027543, -1084185269, -1081340444, -1078493075, -1075643168, -1072790729, -1069935767, -1067078287, -1064218295, -1061355800,
			-1058490807, -1055623323, -1052753356, -1049880911, -1047005996, -1044128616, -1041248781, -1038366494, -1035481765, -1032594599, -1029705003, -1026812984, -1023918549, -1021021705, -1018122458, -1015220815,
			-1012316783, -1009410369, -1006501580, -1003590423, -1000676904, -997761030, -994842809, -991922247, -988999350, -986074126, -983146582, -980216725, -977284561, -974350097, -971413341, -968474299,
			-965532977, -962589384, -959643526, -956695410, -953745042, -950792430, -947837581, -944880502, -941921199, -938959680, -935995951, -933030020, -930061893, -927091578, -924119081, -921144410,
			-918167571, -915188571, -912207418, -909224119, -906238680, -903251109, -900261412, -897269597, -894275670, -891279639, -888281511, -885281292, -882278991, -879274613, -876268167, -873259658,
			-870249094, -867236483, -864221831, -861205146, -858186434, -855165702, -852142958, -849118210, -846091463, -843062725, -840032003, -836999305, -833964637, -830928006, -827889421, -824848887,
			-821806412, -818762004, -815715669, -812667415, -809617248, -806565176, -803511206, -800455345, -797397601, -794337981, -791276491, -788213140, -785147933, -782080880, -779011985, -775941258,
			-772868705, -769794333, -766718150, -763640163, -760560379, -757478805, -754395449, -751310317, -748223418, -745134758, -742044344, -738952185, -735858286, -732762657, -729665302, -726566231,
			-723465451, -720362967, -717258789, -714152923, -711045377, -707936157, -704825271, -701712727, -698598532, -695482693, -692365217, -689246113, -686125386, -683003045, -679879096, -676753548,
			-673626407, -670497682, -667367378, -664235504, -661102067, -657967075, -654830534, -651692452, -648552837, -645411696, -642269036, -639124864, -635979189, -632832017, -629683356, -626533214,
			-623381597, -620228513, -617073970, -613917975, -610760535, -607601658, -604441351, -601279622, -598116478, -594951926, -591785975, -588618631, -585449902, -582279796, -579108319, -575935479,
			-572761285, -569585742, -566408859, -563230644, -560051103, -556870244, -553688075, -550504603, -547319836, -544133780, -540946445, -537757836, -534567962, -531376830, -528184448, -524990823,
			-521795962, -518599874, -515402565, -512204044, -509004317, -505803393, -502601278, -499397981, -496193509, -492987869, -489781068, -486573116, -483364018, -480153783, -476942419, -473729932,
			-470516330, -467301621, -464085812, -460868912, -457650927, -454431865, -451211733, -447990540, -444768293, -441544999, -438320666, -435095302, -431868914, -428641510, -425413097, -422183683,
			-418953276, -415721883, -412489511, -409256169, -406021864, -402786603, -399550395, -396313247, -393075166, -389836160, -386596236, -383355403, -380113668, -376871039, -373627522, -370383127,
			-367137860, -363891729, -360644742, -357396906, -354148229, -350898719, -347648383, -344397229, -341145265, -337892497, -334638935, -331384586, -328129456, -324873555, -321616889, -318359466,
			-315101294, -311842381, -308582733, -305322360, -302061268, -298799466, -295536960, -292273759, -289009870, -285745301, -282480060, -279214154, -275947591, -272680379, -269412525, -266144037,
			-262874923, -259605190, -256334846, -253063900, -249792357, -246520227, -243247517, -239974234, -236700387, -233425983, -230151030, -226875534, -223599506, -220322950, -217045877, -213768293,
			-210490205, -207211623, -203932553, -200653003, -197372981, -194092494, -190811551, -187530158, -184248325, -180966058, -177683365, -174400253, -171116732, -167832808, -164548489, -161263783,
			-157978697, -154693239, -151407418, -148121240, -144834714, -141547847, -138260647, -134973121, -131685278, -128397125, -125108670, -121819920, -118530884, -115241569, -111951983, -108662133,
			-105372028, -102081674, -98791081, -95500255, -92209204, -88917936, -85626459, -82334781, -79042909, -75750851, -72458614, -69166207, -65873638, -62580913, -59288041, -55995030,
			-52701886, -49408619, -46115236, -42821744, -39528151, -36234465, -32940694, -29646846, -26352927, -23058947, -19764912, -16470831, -13176711, -9882561, -6588386, -3294197 };

int LPFilterCoeff_A, LPFilterCoeff_B, FilterHistory, LPFilterHistory;

static void Filter_Init(unsigned long sampling_rate, unsigned long low_crossover_freq) {
  float W = tan(3.14159265 * low_crossover_freq / sampling_rate);
  float N = 1/(1+W);
  LPFilterCoeff_A = (W-1) * N * 32768;
  LPFilterCoeff_B =  1    * N * 65536; // amplitude
  FilterHistory = 0;
  LPFilterHistory = 0;
}

static signed short Filter16(signed short datum) {
  signed long lp = ((signed long)datum - (signed long)FilterHistory) * LPFilterCoeff_B - (signed long)LPFilterHistory * LPFilterCoeff_A;
  FilterHistory = datum;
  LPFilterHistory = lp>>15;
  return (datum - (lp>>16))<<1;
}

int main() {
  int phase = 0, freq = 2048, val, newval, gain = 65536, LastLFVal, avg = 0, cliptimer = 0, flashtimer = 0, lowbatt = 0, LFDataVal;
  int am = 1, fm = 1, boost = 1;
  short LFDataCount, LFDataPos, LFDataBuf[1024], MinLFVal, MaxLFVal, BattVal = 3000, BattTemp = 0, BattCount = 0;

  SYSTEMConfigPerformance(SYS_FREQ);
  INTEnableSystemMultiVectoredInt();
  INTEnableInterrupts();

  Filter_Init(SYS_FREQ / 90 / 128, 3);

  // RB14 = SCK1
  // RB1 = SDO1
  // RB3 = SS1
  LATBbits.LATB14 = 0;
  ANSELBbits.ANSB14 = 0;
  LATBbits.LATB1 = 0;
  ANSELBbits.ANSB1 = 0;
  RPB1Rbits.RPB1R = 3; // SDO1
  LATBbits.LATB3 = 0;
  ANSELBbits.ANSB3 = 0;
  RPB3Rbits.RPB3R = 3; // SS1

  SPI1CON2bits.AUDMOD = 0; // I2S
  SPI1CON2bits.AUDEN = 1;

  SPI1CONbits.DISSDI = 1;
  SPI1CONbits.MSTEN = 1;
  SPI1CONbits.CKP = 1;
  SPI1CONbits.FRMPOL = 0;
  SPI1CONbits.MODE32 = 1;
  SPI1CONbits.ENHBUF = 1;

  SPI1CON2bits.AUDMONO = 1;
  SPI1CON2bits.IGNTUR = 1;

  SPI1BRG = 1;

  SPI1CONbits.ON = 1;

  TRISAbits.TRISA0 = 1;
  ANSELAbits.ANSA0 = 1;
  TRISAbits.TRISA1 = 1;
  ANSELAbits.ANSA1 = 1;
  AD1CHSbits.CH0SA = 0;
  AD1CHSbits.CH0SB = 1;
  AD1CON3bits.ADCS = 5;
  AD1CON3bits.SAMC = 4;
  AD1CON2bits.SMPI = 1;
  AD1CON2bits.BUFM = 1;
  AD1CON2bits.ALTS = 1;
  AD1CON1bits.SSRC = 7;
  AD1CON1bits.FORM = 5;
  IFS0bits.AD1IF = 0;
  AD1CON1bits.ON = 1;
  AD1CON1bits.ASAM = 1;

  TRISBbits.TRISB0 = 0;
  LATBbits.LATB0 = 1;
  ANSELBbits.ANSB0 = 0;
  TRISAbits.TRISA4 = 0;
  LATAbits.LATA4 = 1;

  TRISAbits.TRISA2 = 1;
  TRISAbits.TRISA3 = 1;
  TRISBbits.TRISB2 = 1;
  TRISBbits.TRISB4 = 1;
  ANSELBbits.ANSB2 = 0;
  CNPUAbits.CNPUA2 = 1;
  CNPUAbits.CNPUA3 = 1;
  CNPUBbits.CNPUB2 = 1;
  CNPUBbits.CNPUB4 = 1;

  LFDataVal = 0;
  LFDataCount = 0;
  LFDataPos = 0;
  LastLFVal = 0;
  MinLFVal = 32767;
  MaxLFVal = 0;

  while(1) {
      while( SPI1STATbits.SPITBF ) {
          LATBbits.LATB0 = !cliptimer;
          if( BattVal < 2100 )
              lowbatt = 1;
          else if( BattVal > 2200 )
              lowbatt = 0;
          LATAbits.LATA4 = (lowbatt ? 0 : flashtimer > 1000);

          if( IFS0bits.AD1IF ) {
              if( ++flashtimer == 32768 )
                  flashtimer = 0;
              if( cliptimer )
                  --cliptimer;

              if( !AD1CON2bits.BUFS ) {
                  LFDataVal += (short)ADC1BUF0;
                  BattTemp += (short)ADC1BUF1 + 512;
              } else {
                  LFDataVal += (short)ADC1BUF8;
                  BattTemp += (short)ADC1BUF9 + 512;
              }

              if( ++BattCount == 4 ) {
                  BattVal = BattTemp;
                  BattTemp = 0;
                  BattCount = 0;
              }
              if( ++LFDataCount == 128 ) {
                  LFDataVal >>= 2;
                  if( boost )
                      LFDataVal = Filter16(LFDataVal);

                  avg = avg - (avg>>8) + LFDataVal;
                  LFDataVal -= avg>>8;
                  if( LFDataVal > 16000 || LFDataVal < -16000 )
                      cliptimer = 1000;

                  LastLFVal = LFDataVal;
                  if( LastLFVal < 0 )
                      LastLFVal = -LastLFVal;
                  if( LastLFVal < MinLFVal )
                      MinLFVal = LastLFVal;
                  if( LastLFVal > MaxLFVal )
                      MaxLFVal = LastLFVal;

                  freq = 2048 + (fm ? (LFDataVal>>4) : 0);
                  if( freq < 512 )
                      freq = 512;
                  else if( freq > 8192 )
                      freq = 8192;
                  if( LastLFVal > 32767 || !am )
                      LastLFVal = 32767;
                  else if( LastLFVal < -32767 )
                      LastLFVal = -32767;

                  LFDataVal = 0;
                  LFDataCount = 0;
                  if( ++LFDataPos == sizeof(LFDataBuf)/sizeof(*LFDataBuf) ) {
                      LFDataPos = 0;
                      if( MaxLFVal < 0x7000 && gain < 65536 * 4 ) {
                          gain += 0x100;
                      } else if( MaxLFVal > 0x6000 && gain > 65536 ) {
                          gain -= 0x100;
                      }
                      MinLFVal = 32767;
                      MaxLFVal = 0;
                  }
              } else {
                  if( !PORTBbits.RB4 ) {
                      am = 1;
                      fm = 1;
                      boost = 0;
                  } else if( !PORTAbits.RA3 ) {
                      am = 1;
                      fm = 0;
                      boost = 1;
                  } else if( !PORTAbits.RA2 ) {
                      am = 1;
                      fm = 0;
                      boost = 0;
                  } else if( !PORTBbits.RB2 ) {
                      am = 0;
                      fm = 1;
                      boost = 0;
                  } else {
                      am = 1;
                      fm = 1;
                      boost = 1;
                  }
              }
              IFS0bits.AD1IF = 0;
          }
      }

      newval = ( ((long long)Sinewave[phase>>8] * LastLFVal * gain)>>(8+15+16+1))+(32768<<8);
      val = ((val<<2) - val + newval) >> 2;
      SPI1BUF = val;
      phase += freq;
      if( phase >= 4096 * 256 )
          phase -= 4096 * 256;
  }

  return (EXIT_SUCCESS);
}

